package gov.va.med.mhv.health.web.form.bean;

import java.text.SimpleDateFormat;

import gov.va.med.mhv.health.dto.MilitaryHistoryDTO;
import gov.va.med.mhv.health.enums.BranchEnumeration;
import gov.va.med.mhv.health.enums.LocationEnumeration;
import gov.va.med.mhv.health.enums.OnboardShipEnumeration;

public class MilitaryHistory extends MilitaryHistoryDTO {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7712090222016048180L;

	public String getDisplayEventDate() {
		SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
		String displayEventDate = formatter.format(super.getEventDate());
		return displayEventDate;
	}

	public BranchEnumeration[] getBranches() {
		return BranchEnumeration.values();
	}

	public LocationEnumeration[] getLocations() {
		return LocationEnumeration.values();
	}

	public OnboardShipEnumeration[] getOnboards() {
		return OnboardShipEnumeration.values();
	}

	public String getDisplayServiceBranch() {

		String displayServiceBranch = "";

		BranchEnumeration[] branches = getBranches();
		for (BranchEnumeration branch : branches) {
			if (branch.getCode().equalsIgnoreCase(getServiceBranch())) {
				displayServiceBranch = branch.getDescription();
				break;
			}
		}

		return displayServiceBranch;
	}

	public String getDisplayLocation() {
		String displayLocation = "";

		LocationEnumeration[] locations = getLocations();
		for (LocationEnumeration location : locations) {
			if (location.getCode().equalsIgnoreCase(getServiceLocation())) {
				displayLocation = location.getDescription();
				break;
			}
		}
		return displayLocation;
	}

	public String getDisplayOnboardShip() {
		String displayOnboardShip = "";

		OnboardShipEnumeration[] onboards = getOnboards();
		for (OnboardShipEnumeration onboard : onboards) {
			if (onboard.getCode().equalsIgnoreCase(getServiceLocation())) {
				displayOnboardShip = onboard.getDescription();
				break;
			}
		}

		return displayOnboardShip;

	}

}
